<?php

namespace App\Notifications;

use App\Models\ForumThread;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class ThreadReactionNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $reactor;
    protected $thread;
    protected $reactionType;

    /**
     * Create a new notification instance.
     */
    public function __construct(User $reactor, ForumThread $thread, string $reactionType)
    {
        $this->reactor = $reactor;
        $this->thread = $thread;
        $this->reactionType = $reactionType;
    }

    /**
     * Get the notification's delivery channels.
     */
    public function via(object $notifiable): array
    {
        return ['database'];
    }

    /**
     * Get the array representation of the notification.
     */
    public function toDatabase(object $notifiable): array
    {
        return [
            'reactor_id' => $this->reactor->id,
            'reactor_name' => $this->reactor->name,
            'reactor_avatar' => $this->reactor->avatar,
            'thread_id' => $this->thread->id,
            'thread_title' => $this->thread->title,
            'thread_slug' => $this->thread->slug,
            'board_slug' => $this->thread->board->slug,
            'reaction_type' => $this->reactionType,
            'reaction_emoji' => \App\Models\ForumReaction::getTypes()[$this->reactionType] ?? '',
            'message' => "{$this->reactor->name} reacted to your thread \"{$this->thread->title}\"",
            'url' => route('forum.thread', [$this->thread->board->slug, $this->thread->slug])
        ];
    }
}